IF EXISTS
(
    SELECT
		 *
    FROM sys.views
    WHERE object_id = OBJECT_ID(N'[dbo].[V_EST_SNGPC_VENDAS]')
)
	DROP VIEW[dbo].[V_EST_SNGPC_VENDAS];
GO

CREATE VIEW dbo.V_EST_SNGPC_VENDAS
AS
WITH TREGINV AS (
SELECT
   F.CD_EMP
   ,F.CD_FILIAL
   ,(SELECT MAX (DT)
      FROM (VALUES  (DT_INVT), (F.DT_INI_SISTEMA) ) AS VALUE(DT)) AS DATA
FROM
   PRC_FILIAL F WITH (NOLOCK)
   LEFT JOIN (SELECT
                  B.CD_EMP
                  ,B.CD_FILIAL
                  ,MAX(B.DT_REINICIO) DT_INVT
              FROM
                  EST_SNGPC_REINICIO_INVENTARIO B WITH (NOLOCK)
              GROUP  BY
                  B.CD_EMP
                  ,B.CD_FILIAL) I ON
       F.CD_EMP = I.CD_EMP AND
       F.CD_FILIAL = I.CD_FILIAL
)       
,ENVIO AS (
  SELECT                                       
     B.CD_EMP,
     B.CD_FILIAL,
     MAX(DT_FINAL)  AS FDATA                             
  FROM                                          
      EST_SNGPC_RELATORIOS_ANVISA  B            
  WHERE                                         
   B.ACEITO   =1                               
  GROUP BY
    B.CD_EMP,
    B.CD_FILIAL
  )                 
                                
SELECT                              
    V.CD_EMP                                
    , V.CD_FILIAL                            
    , V.CD_VD
    , V.CD_CX
    , V.NR_ECF
    , V.NR_ORC
    , A.DT_VD
    , A.CD_VEND
    , COALESCE(FUN.NM_FUN, 'NO DEFINIDO') AS NM_FUN  
    ,CLI.RZ_CLI
    , V.VLR_LIQ_VD
    , (CASE WHEN V.NR_PED_TELEVD = 0 THEN 'BALCO'
            ELSE 'TELEVENDAS' END) AS ORIGEM
    ,SUM (COALESCE( A.QT_IT - CCL.QT_CANCEL, A.QT_IT)) AS QT_IT
    ,MAX (COALESCE(L.LANCADO,0))  AS LANCADO
FROM              
    PDV_VD V WITH (NOLOCK)
    INNER JOIN PDV_VD_IT A ON
    V.CD_EMP    = A.CD_EMP AND
    V.CD_FILIAL = A.CD_FILIAL AND
    V.CD_VD        = A.CD_VD AND
    V.DT_VD        = A.DT_VD
    LEFT JOIN (SELECT
                    D.CD_EMP,
                    D.CD_FILIAL,
                    D.CD_VD,  
                    SUM(SAI.QT_LOTE) LANCADO                                              
                FROM                                                              
                    EST_SNGPC_SAIDA AS SAI  WITH (NOLOCK)                                        
                    INNER JOIN   PDV_VD_IT_EST_SNGPC_SAIDA  D ON  
                    D.CD_SAI_SNGPC =  SAI.CD_SAI_SNGPC
                GROUP BY D.CD_EMP,
                    D.CD_FILIAL,
                    D.CD_VD            ) L ON
    V.CD_EMP    = L.CD_EMP AND
    V.CD_FILIAL = L.CD_FILIAL AND
    V.CD_VD        = L.CD_VD 
    
-----------------------------------------------------------          
INNER JOIN ENVIO TENVIO ON
    V.CD_EMP    = TENVIO.CD_EMP AND
    V.CD_FILIAL = TENVIO.CD_FILIAL AND
    V.DT_VD        > TENVIO.FDATA
-----------------------------------------------------------          
-----------------------------------------------------------          
INNER JOIN TREGINV TMP ON
    V.CD_EMP    = TMP.CD_EMP AND
    V.CD_FILIAL = TMP.CD_FILIAL AND
    V.DT_VD        > TMP.DATA
-----------------------------------------------------------      
LEFT JOIN RC_CLI AS CLI ON
        V.CD_EMP        = CLI.CD_EMP
        AND V.CD_CLI    = CLI.CD_CLI
-----------------------------------------------------------    
LEFT JOIN FP_FUNC AS FUN ON
        A.CD_EMP        = FUN.CD_EMP
        AND A.CD_VEND   = FUN.CD_FUN
-----------------------------------------------------------                            
INNER JOIN EST_PROD P ON                
  A.CD_EMP = P.CD_EMP 
 AND A.CD_PROD = P.CD_PROD  
                
-----------------------------------------------------------
LEFT JOIN PDV_VD_IT_EST_SNGPC_PENDENTE_CANCELADO AS CCL ON
 A.CD_EMP = CCL.CD_EMP
 AND A.CD_FILIAL = CCL.CD_FILIAL
 AND A.CD_VD = CCL.CD_VD
 AND A.CD_IT = CCL.CD_IT
WHERE  
    P.CONTROLE_SNGPC  =1  
    AND A.CD_EMP=1
    AND V.ST_VD = 0
    AND A.ST_IT = 1
GROUP  BY
  V.CD_EMP                                
 , V.CD_FILIAL                            
 , V.CD_VD  
 , V.CD_CX
 , V.NR_ECF
 , V.NR_ORC
 , A.DT_VD
 , A.CD_VEND
 , FUN.NM_FUN
 , V.VLR_LIQ_VD
 , V.NR_PED_TELEVD
 , CLI.RZ_CLI